//See the following tutorial
//https://docs.oracle.com/javafx/2/ui_controls/table-view.htm

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package javaFX;

import datasource.InMemoryDataSource;
import java.util.List;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import products.Item;
import products.WritingImplement;

/**
 *
 * @author mtthw
 */
public class DisplayPriceLists1 extends Application {
    
    private TableView table = new TableView();
            
    private InMemoryDataSource datasource = new InMemoryDataSource();
    private List<Item> list =datasource.retrieveList("Demo").getList();
    ObservableList<Item> data = FXCollections.observableArrayList(list);
    
    @Override
    public void start(Stage primaryStage) {
        
        //Create some extra price lists for our datasource
        datasource.saveList("Empty",datasource.retrieveList("Demo").filterList(i->false));
        datasource.saveList("Writing Implements",datasource.retrieveList("Demo").filterList(i->i instanceof WritingImplement));
        
        
        final Label label = new Label("Price Lists");
//        label.setFont(new Font("Arial", 20));
 
        table.setEditable(true);
 
        TableColumn nameCol = new TableColumn("Name");
        nameCol.setMinWidth(150);
        TableColumn descriptionCol = new TableColumn("Description");
        descriptionCol.setMinWidth(425);
        TableColumn priceCol = new TableColumn("Price");
        priceCol.setMinWidth(75);
        table.getColumns().addAll(nameCol, descriptionCol, priceCol);
        
        nameCol.setCellValueFactory(new PropertyValueFactory<Item,String>("name"));
        descriptionCol.setCellValueFactory(new PropertyValueFactory<Item,String>("description"));
        priceCol.setCellValueFactory(new PropertyValueFactory<Item,Double>("price"));
        
        //Set the data to the empty price list to start
//        list =datasource.retrieveList("Demo").getList();
//        data = FXCollections.observableArrayList(list);
        table.setItems(data);
        
        //Creating a combo box 
        ObservableList<String> priceListNames = FXCollections.observableArrayList(datasource.lists.keySet());        
        ComboBox comboBox = new ComboBox(priceListNames);
        
        //Modify the button
        Button btn = new Button();
        btn.setText("Change Price List");
        btn.setOnAction(new EventHandler<ActionEvent>() {
            @Override
            public void handle(ActionEvent event) {
                //Set the data to the empty price list to start
                list =datasource.retrieveList(comboBox.getValue().toString()).getList();
                data = FXCollections.observableArrayList(list);
                table.setItems(data);
            }
        });
        
        //Put the button and the combo box in a HBox before adding it to the BorderPane.
        HBox toolbar = new HBox();
        toolbar.getChildren().addAll(comboBox,btn);
        
        BorderPane root = new BorderPane();
        root.setBottom(toolbar);
        root.setTop(label);
        root.setCenter(table);
        
        Scene scene = new Scene(root, 650, 250);
        
        primaryStage.setTitle("Price List Application");
        primaryStage.setWidth(650);
        primaryStage.setHeight(500);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        launch(args);
    }
    
}
